Test_Sensors = class()

function Test_Sensors:init()
    self.title = "sensors"
    self.unit = WIDTH * 0.1
end

function Test_Sensors:setup()
    self.lab = PhysicsLab()
    self.lab:makePetrieDish()
    self.circle = self.lab:circleAt(WIDTH/2,HEIGHT/2, self.unit)
    self.circle.type = STATIC
    self.lab:makeSensor(self.circle, function(contact)
        if contact.bodyA.sensor or contact.bodyB.sensor then
            if contact.state == BEGAN then
                print("Circle detected contact BEGAN")
            elseif contact.state == MOVING then
                print("Circle detected contact MOVING")
            else
                print("Circle detected contact ENDED")
            end
        end
    end)
    local box = self.lab:boxAt(WIDTH/2, HEIGHT/2 + 100, self.unit, self.unit)
    print("Sensors detect bodies without causing collisions. Any body can be one.\n\nNormally you define sensors and their behavior separately. Using PhysicsLab you can set a sensor and its behavior at the same time.")
end

function Test_Sensors:draw()
    self.lab:draw()
end

function Test_Sensors:touched(touch)
    self.lab:touched(touch)
end

function Test_Sensors:collide(contact)
    self.lab:collide(contact)
end

function Test_Sensors:cleanup()
    self.lab:clear()
end